/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.items;

import com.itayfeder.gelato_galore.GelatoGaloreConfig;
import com.itayfeder.gelato_galore.client.renderers.IceCreamItemRenderer;
import com.itayfeder.gelato_galore.reload.FlavorData;
import com.itayfeder.gelato_galore.reload.FlavorDataReloadListener;
import com.itayfeder.gelato_galore.toppings.TickableTopping;
import com.itayfeder.gelato_galore.toppings.Topping;
import com.itayfeder.gelato_galore.toppings.Toppings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class IceCreamItem
extends Item {
    public final int scoops;
    public static final int MAX_SCOOPS = 3;

    public IceCreamItem(int scoops, Item.Properties p_41383_) {
        super(p_41383_.m_41489_(new FoodProperties.Builder().m_38760_(2 * scoops).m_38758_(0.2f * (float)scoops).m_38767_()));
        this.scoops = scoops;
    }

    public ItemStack m_5922_(ItemStack p_41409_, Level p_41410_, LivingEntity p_41411_) {
        if (!p_41410_.f_46443_ && ((Boolean)GelatoGaloreConfig.ServerConfig.ICECREAM_EFFECT.get()).booleanValue()) {
            List<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
            for (int i = 0; i < this.scoops; ++i) {
                MobEffectInstance instance = this.getFlavor((ItemStack)p_41409_, (int)i).effect.construct();
                if (instance == null) continue;
                instances.add(instance);
            }
            instances = IceCreamItem.getTopping(p_41409_).editAppliedEffects(instances);
            for (MobEffectInstance effectInstance : instances) {
                p_41411_.m_7292_(effectInstance);
            }
        }
        return super.m_5922_(p_41409_, p_41410_, p_41411_);
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        return stack;
    }

    public void defaultBuild(ItemStack stack) {
        this.setFlavor(stack, FlavorDataReloadListener.getSidedMap().values().stream().toList().get(0), 0);
        this.setFlavor(stack, FlavorDataReloadListener.getSidedMap().values().stream().toList().get(1), 1);
        this.setFlavor(stack, FlavorDataReloadListener.getSidedMap().values().stream().toList().get(2), 2);
        IceCreamItem.setTopping(stack, Toppings.EMPTY);
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (IceCreamItem.getTopping(p_41404_) instanceof TickableTopping) {
            ((TickableTopping)IceCreamItem.getTopping(p_41404_)).tick(p_41404_, p_41405_);
        }
    }

    public void setFlavor(ItemStack p_220011_0_, FlavorData p_220011_1_, int location) {
        int i;
        CompoundTag compoundnbt = p_220011_0_.m_41784_();
        ResourceLocation[] currentFlavors = new ResourceLocation[this.scoops];
        ListTag flavorTag = compoundnbt.m_128437_("Flavors", 10);
        if (flavorTag.size() == 0) {
            currentFlavors = new ResourceLocation[this.scoops];
            for (i = 0; i < this.scoops; ++i) {
                currentFlavors[i] = FlavorDataReloadListener.getSidedMap().values().stream().toList().get((int)0).id;
            }
        }
        for (i = 0; i < flavorTag.size(); ++i) {
            CompoundTag tag = flavorTag.m_128728_(i);
            currentFlavors[i] = ResourceLocation.m_135820_((String)tag.m_128461_(String.valueOf(i)));
        }
        if (currentFlavors.length > location) {
            currentFlavors[location] = p_220011_1_.id;
        }
        compoundnbt.m_128365_("Flavors", (Tag)this.toListTag(currentFlavors));
    }

    public ListTag toListTag(ResourceLocation[] resources) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < resources.length; ++i) {
            CompoundTag tag = new CompoundTag();
            if (resources[i] != null) {
                tag.m_128359_(String.valueOf(i), resources[i].toString());
            } else {
                tag.m_128359_(String.valueOf(i), "gelato_galore:chocolate");
            }
            tagList.add((Object)tag);
        }
        return tagList;
    }

    public FlavorData getFlavor(ItemStack p_220012_0_, int location) {
        CompoundTag compoundnbt = p_220012_0_.m_41784_();
        ListTag currentFlavors = compoundnbt.m_128437_("Flavors", 10);
        if (currentFlavors.size() == 0) {
            return FlavorDataReloadListener.getSidedMap().values().stream().toList().get(0);
        }
        if (location >= currentFlavors.size()) {
            return FlavorDataReloadListener.getSidedMap().values().stream().toList().get(0);
        }
        CompoundTag tag = currentFlavors.m_128728_(location);
        ResourceLocation relocation = ResourceLocation.m_135820_((String)tag.m_128461_(String.valueOf(location)));
        return relocation != null ? FlavorDataReloadListener.getSidedMap().get(relocation) : FlavorDataReloadListener.getSidedMap().values().stream().toList().get(0);
    }

    public static void setTopping(ItemStack p_220011_0_, Topping topping) {
        CompoundTag compoundnbt = p_220011_0_.m_41784_();
        compoundnbt.m_128365_("Topping", (Tag)topping.createTag());
    }

    public static Topping getTopping(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41784_();
        return Topping.readTag(compoundnbt.m_128469_("Topping"));
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        for (int i = 0; i < this.scoops; ++i) {
            if (this.getFlavor(p_41421_, i) == null) {
                p_41423_.add((Component)Component.m_237110_((String)"flavor.unknown", (Object[])new Object[0]).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                continue;
            }
            p_41423_.add((Component)Component.m_237110_((String)("flavor." + this.getFlavor((ItemStack)p_41421_, (int)i).name), (Object[])new Object[0]).m_130948_(Style.f_131099_.m_178520_(this.getFlavor((ItemStack)p_41421_, (int)i).color)));
        }
        if (!IceCreamItem.getTopping((ItemStack)p_41421_).location.equals((Object)Toppings.EMPTY.location)) {
            p_41423_.add((Component)Component.m_237110_((String)"tooltip.gelato_galore.topping", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(IceCreamItem.getTopping(p_41421_).getText()));
        }
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }

    public String m_5671_(ItemStack p_41455_) {
        return "item.gelato_galore.ice_cream";
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new IceCreamItemRenderer();
            }
        });
    }
}

